<?php
	// Mobile Page
?>
<!DOCTYPE HTML>
<html lang="en-US">
<head>
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
	<title><?php bloginfo('name'); ?> <?php if ( is_single() ) { ?> &raquo; Blog Archive <?php } ?> <?php wp_title(); ?></title>
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats -->
	
	<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/960.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
	<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<link href='http://fonts.googleapis.com/css?family=Numans' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Droid+Sans:400,700' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Lobster' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Ubuntu&subset=latin,cyrillic,latin-ext,greek,greek-ext,cyrillic-ext' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Days+One' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Droid+Serif' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Volkhov' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Old+Standard+TT:400,400italic,700' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Arvo:400,400italic,700,700italic' rel='stylesheet' type='text/css'>

	
	<?php if (get_option('calltoaction-bg') != "") { ?>
			<style type="text/css">
				body {
					background: url(<?php echo get_option('calltoaction-bg'); ?>) repeat-x top #f0f0f0 !important;
				}
			</style>
	<?php } ?>
	
	<?php if (get_option('typography') == "type-1") { ?>
			<style type="text/css">
				body {
					font-family: 'Numans', sans-serif  !important;
				}
				p {
					font-family: 'Numans', sans-serif  !important;
				}
				h1, h2, h3, h4, h5 {
					font-family: 'Droid Sans', sans-serif  !important;
				}
				#nav h1 a {
					padding-top: 18px;
				}
			</style>
	<?php } ?>
	<?php if (get_option('typography') == "type-2") { ?>
			<style type="text/css">
				body {
					font-family: 'Ubuntu', sans-serif !important;
				}
				p {
					font-family: 'Ubuntu', sans-serif !important;
				}
				h1, h2, h3, h4, h5 {
					font-family: 'Days One', sans-serif  !important;
				}
			</style>
	<?php } ?>
	<?php if (get_option('typography') == "type-3") { ?>
			<style type="text/css">
				body {
					font-family: 'Droid Serif', sans-serif !important;
				}
				p {
					font-family: 'Droid Serif', sans-serif !important;
				}
				h1, h2, h3, h4, h5 {
					font-family: 'Volkhov', sans-serif  !important;
				}
			</style>
	<?php } ?>
	<?php if (get_option('typography') == "type-4") { ?>
			<style type="text/css">
				body {
					font-family: 'Arvo', sans-serif !important;
				}
				p {
					font-family: 'Arvo', sans-serif !important;
				}
				h1, h2, h3, h4, h5 {
					font-family: 'Old Standard TT', sans-serif  !important;
				}
			</style>
	<?php } ?>
	
	<style type="text/css">
		#logo h1 a {
			color: #<?php echo get_option('logo_color'); ?>;
		}
		#logo h3 {
			color: #<?php echo get_option('logo_color'); ?>;
		}
		#nav ul li a {
			color: #<?php echo get_option('nav_color'); ?>;
		}
		#calltoaction h2 {
			color: #<?php echo get_option('cta_color'); ?>;
		}
		#calltoaction h4 {
			color: #<?php echo get_option('cta_color'); ?>;
		}
		#content h1 {
			color: #<?php echo get_option('headline_color'); ?>;
		}
		#content h2 {
			color: #<?php echo get_option('headline_color'); ?>;
		}
	</style>
	<meta name="viewport" content="width=400, initial-scale=.9, maximum-scale=.9, user-scalable=no">
</head>
<body class="<?php echo get_option('bg-style'); ?>">
	<div id="wrapper" class="container_12" style="width: 330px; margin:0;">
		<div id="header"  class="grid_5" style="width: 330px;">
			<div id="logo">
				<?php if (get_option('calltoaction-logo') != "") { ?>
						<img src="<?php echo get_option('calltoaction-logo'); ?>" alt="">
				<?php } else { ?>
					<h1><a href="<?php echo get_option('home'); ?>"><?php echo get_option('logo'); ?></a></h1>
					<h3><?php echo get_option('tagline'); ?></h3>
				<?php } ?>
			</div>
		</div>
		<div id="nav"  class="grid_5" style="width: 320px;">
			<?php if (get_option('calltoaction-fanpage') != "") { ?>
					<a href="<?php echo get_option('calltoaction-fanpage'); ?>" style="float: right; margin: 10px 5px; margin-bottom: 0;"><img src="http://cdn4.iconfinder.com/data/icons/Classy_Social_Media_Icons/16/facebook.png" style="border: none"></a>
			<?php } ?>
			<?php if (get_option('calltoaction-places') != "") { ?>
					<a href="<?php echo get_option('calltoaction-places'); ?>" style="float: right; margin: 10px 5px; margin-bottom: 0;"><img src="http://cdn4.iconfinder.com/data/icons/Classy_Social_Media_Icons/16/map.png" style="border: none"></a>
			<?php } ?>
		
			<?php

				function displayMenuHelp() {
					?>
						<h5  style="float: left; padding: 9px; padding-left: 0; color: #fff !important; padding-bottom: 15px !important; display: block; font-size: 13px; font-weight: normal !important">Create menu called "Mobile Menu"</h5>
					<?php
				}

			?>
				<?php wp_nav_menu( array( 'menu' => 'mobile-menu', 'fallback_cb' => 'displayMenuHelp' ) ); ?>
		</div>
		
			 <?php if (get_option('mobileBanner') != "") { ?>
					<div id="banner"  class="grid_5" style="width: 330px;">
						<img src="<?php echo get_option('mobileBanner'); ?>" style="">
					</div>
			<?php } else {echo "<br clear='all' /> <br/><br/><style>#calltoaction-mobile h4 {color: #fff; opacity: .5;}#calltoaction-mobile h2 a {color: #fff;}</style>"; } ?>
			
		
		<div id="calltoaction-mobile"  class="grid_4" style="width: 280px; margin-left: 30px;">
			<h4><?php echo get_option('calltoaction-subheadline'); ?></h4>
			<h2><a href="tel:<?php echo get_option('calltoaction-headline'); ?>" style="text-decoration: none"><?php echo get_option('calltoaction-headline'); ?></a></h2>
		</div>
		<div id="content"  class="grid_3" style="width:330px;">
			<div class="grid_4 column">
				<?php if (get_option('headline1') == "") { ?>
					<h2>Welcome to SiteCrusherTheme</h2>
				<?php } else { ?>
					<h2><?php echo html_entity_decode(get_option('headline1')); ?></h2>
				<?php } ?>
				<?php if (get_option('subheadline1') == "") { ?>
					<h4>Customize Everything Inside Your Theme</h4>
				<?php } else { ?>
					<h4><?php echo html_entity_decode(get_option('subheadline1')); ?></h4>
				<?php } ?>
				<div style="clear:both; padding-top: 5px;">
					<?php if (get_option('content') == "") { ?>
						<p>Your theme is now activated! You can edit all of the text you are reading on this page. Including the logo, banner image, bg image and much more!</p>
					<?php } else { ?>
						<?php echo html_entity_decode(get_option('content')); ?>
					<?php } ?>
				</div>

				<?php if (get_option('readmore1') == "") { ?>
					<a href="#" class="readmore">Add Your Link/Text Here</a>
				<?php } else { ?>
					<a href="<?php echo get_option('readmoreURL1'); ?>" class="readmore"><?php echo get_option('readmore1'); ?></a>
				<?php } ?>
			</div>
			<div class="grid_4 column">
				<?php if (get_option('headline2') == "") { ?>
					<h2>Admin Options Panel</h2>
				<?php } else { ?>
					<h4><?php echo html_entity_decode(get_option('headline2')); ?></h4>
				<?php } ?>
				<?php if (get_option('subheadline2') == "") { ?>
					<h4>Customize Everything Inside Your Theme</h4>
				<?php } else { ?>
					<h4><?php echo html_entity_decode(get_option('subheadline2')); ?></h4>
				<?php } ?>
				<div style="clear:both; padding-top: 5px;">
					<?php if (get_option('content2') == "") { ?>
						<p>Inside your wordpress dashboard under Appearances you will find the admin options panel. Here you can edit all of the content and styling of this page.</p>
					<?php } else { ?>
						<?php echo html_entity_decode(get_option('content2')); ?>
					<?php } ?>
				</div>
				<?php if (get_option('readmore2') == "") { ?>
					<a href="#" class="readmore">Add Your Link/Text Here</a>
				<?php } else { ?>
					<a href="<?php echo get_option('readmoreURL2'); ?>" class="readmore"><?php echo get_option('readmore2'); ?></a>
				<?php } ?>
			</div>
			<div class="grid_4 column">
				<?php if (get_option('headline3') == "") { ?>
					<h2>Customize Graphics</h2>
				<?php } else { ?>
					<h2><?php echo html_entity_decode(get_option('headline3')); ?></h2>
				<?php } ?>
				<?php if (get_option('subheadline3') == "") { ?>
					<h4>Customize Everything Inside Your Theme</h4>
				<?php } else { ?>
					<h4><?php echo html_entity_decode(get_option('subheadline3')); ?></h4>
				<?php } ?>
				<div style="clear:both; padding-top: 5px;">
					<?php if (get_option('content3') == "") { ?>
						<p>Inside your wordpress options you will find you have the ability to customize text logo, but also add your images for logo, background and huge banner graphic!</p>
					<?php } else { ?>
						<?php echo html_entity_decode(get_option('content3')); ?>
					<?php } ?>
				</div>
				<?php if (get_option('readmore3') == "") { ?>
					<a href="#" class="readmore">Add Your Link/Text Here</a>
				<?php } else { ?>
					<a href="<?php echo get_option('readmoreURL3'); ?>" class="readmore"><?php echo get_option('readmore3'); ?></a>
				<?php } ?>
			</div>
		</div>
		<div id="footer"  style="width:330px;padding-top: 0; text-align: center;">
			<p style="font-size: 11px; padding: 0 30px;">Copyright &copy; 2011 - <?php echo get_option('logo'); ?> - <?php echo get_option('tagline'); ?> - All Rights Reserved!</p>
			<p style="font-size: 10px;"><strong>Powered by Site Crusher Theme - SuccessBug, Ltd</strong></p>
		</div>
	</div>
</body>
</html>